/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CThreadImp.h,v 1.2 1999/09/17 04:20:45 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CThreadImp_h	// [
#define Included_CThreadImp_h

#include "pgpClassesConfig.h"

#include "CImp.h"
#include "CLookasideList.h"
#include "CQueue.h"
#include "CSemaphore.h"
#include "CSpinLock.h"
#include "CThread.h"

_PGP_BEGIN

// Class CThreadImp

class CThreadImp : public CImp
{
	friend class CThread;

private:
	struct ThreadCallbackInfo;

public:
	~CThreadImp();

protected:
	CThreadImp();

	PGPBoolean	IsRunning() const {return mIsRunning;}

	SMART_ERROR	StartThread(PGPUInt32 maxQueuedRequests);
	void		KillThread();

	SMART_ERROR	PerformAsyncCallback(CThread::CallbackFunc callbackFunc, 
		void *refPtr);
	SMART_ERROR	PerformSyncCallback(CThread::CallbackFunc callbackFunc, 
		void *refPtr);

protected:
	CQueue<ThreadCallbackInfo>	mTaskQueue;
	CArray<ThreadCallbackInfo>	mTaskPool;

	CSpinLock	mTaskQueueLock;
	CSpinLock	mTaskPoolLock;
	CSemaphore	mExitSemaphore;
	CSemaphore	mTaskSemaphore;

	PGPBoolean	mIsRunning;
	PGPBoolean	mShouldWeExit;

	virtual SMART_ERROR	StartOsThread() = 0;

	ThreadCallbackInfo *	GetFromPool();
	void					ReleaseToPool(ThreadCallbackInfo *pTCI);

	PGPBoolean	MainThreadLoop();
};

_PGP_END

#endif	// ] Included_CThreadImp_h
